/*
 * Decompiled with CFR 0.152.
 */
package com.example.demo;

import com.example.demo.CustomTokenConverter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;

@Configuration
@EnableAuthorizationServer
public class AuthServerConfig
extends AuthorizationServerConfigurerAdapter {
    private final UserDetailsService userService;
    private final PasswordEncoder passwordEncoder;
    @Value(value="${user.oauth.clientId}")
    private String ClientID;
    @Value(value="${user.oauth.clientSecret}")
    private String ClientSecret;
    @Value(value="${user.oauth.redirectUris}")
    private String RedirectURLs;
    @Value(value="${user.oauth.signingKey}")
    private String jwtSigningKey;

    public AuthServerConfig(UserDetailsService userService, PasswordEncoder passwordEncoder) {
        this.userService = userService;
        this.passwordEncoder = passwordEncoder;
    }

    public void configure(AuthorizationServerSecurityConfigurer oauthServer) throws Exception {
        oauthServer.tokenKeyAccess("permitAll()").checkTokenAccess("isAuthenticated()");
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        System.out.println(this.RedirectURLs);
        clients.inMemory().withClient(this.ClientID).additionalInformation(new String[]{"email", "ijcadmin"}).secret(this.passwordEncoder.encode((CharSequence)this.ClientSecret)).authorizedGrantTypes(new String[]{"authorization_code"}).scopes(new String[]{"user_info"}).autoApprove(true).redirectUris(new String[]{this.RedirectURLs});
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) {
        endpoints.accessTokenConverter((AccessTokenConverter)this.accessTokenConverter()).userDetailsService(this.userService);
    }

    @Bean
    JwtAccessTokenConverter accessTokenConverter() {
        CustomTokenConverter converter = new CustomTokenConverter();
        converter.setSigningKey(this.jwtSigningKey);
        return converter;
    }
}

